<div class="row">
    <!--  table area -->
    <div class="col-sm-12">

        <div class="panel panel-bd">

            <div class="panel-heading panel-aligner">
                <div class="panel-title">
                    <h4><?php echo "Internee Assessment" ?></h4>
                </div>
            </div>

            <?php
            if ($message = $this->session->flashdata('message')){ ?>
                <div class="alert alert-success"><?php echo $message; ?></div>
            <?php }
            ?>

            <div class="panel-body">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo display('cid') ?></th>
                        <th><?php echo display('name') ?></th>
                        <th><?php echo display('can_id') ?></th>
                        <th><?php echo display('job_adv_id') ?></th>
                        <th><?php echo display('date_of_shortlist') ?></th>
                        <th><?php echo "Action" ?></th>

                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($shortlist)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($shortlist as $que) { ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td><?php echo $sl; ?></td>
                                <td><?php echo $que->firstname . ' ' . $que->lastname; ?></td>
                                <td><?php echo $que->can_id; ?></td>
                                <td><?php echo $que->position_name; ?></td>
                                <td><?php echo $que->date_of_shortlist; ?></td>
                                <td>
                                    <?php
                                    if ($que->assessment_email == 1) { ?>
                                        <em style="color: green;">Email Sent!</em>
                                    <?php } else { ?>
                                        <button type="button" class="btn btn-warning" data-target="#assessmentModel"
                                                data-toggle="modal"
                                                onclick="getCanData('<?php echo $que->can_id ?>','<?php echo $que->email ?>')">
                                            Send Assessment
                                        </button>
                                    <?php }
                                    ?>
                                </td>
                            </tr>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->
            </div>
        </div>
    </div>
</div>

<div id="assessmentModel" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <strong> <?php echo "Add Assessment" ?></strong>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">
                                    <h4>Assessment Form</h4>
                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('recruitment/Candidate_select/intern_assessment') ?>

                                <input type="hidden" id="can_id" name="can_id" value="">
                                <input type="hidden" id="can_email" name="can_email" value="">
                                <input type="hidden" id="page" name="page" value="intern">

                                <div class="form-group row">
                                    <label for="assessment_title" class="col-sm-3 col-form-label"><?php echo "Title" ?>
                                        *</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="assessment_title" class="form-control"
                                               placeholder="Title" id="assessment_title">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="assessment_desc"
                                           class="col-sm-3 col-form-label"><?php echo "Description" ?> *</label>
                                    <div class="col-sm-9">
                                        <textarea name="assessment_desc" id="assessment_desc" placeholder="Description"
                                                  cols="50" rows="5"></textarea>
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="assessment_deadline"
                                           class="col-sm-3 col-form-label"><?php echo "Deadline" ?> *</label>
                                    <div class="col-sm-9">
                                        <input type="date" name="assessment_deadline" class="form-control"
                                               placeholder="Deadline" id="assessment_deadline">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <label for="assessment_attachment"
                                           class="col-sm-3 col-form-label"><?php echo "Attachment" ?> *</label>
                                    <div class="col-sm-9">
                                        <input type="file" name="assessment_attachment" class="form-control"
                                               id="assessment_attachment">
                                    </div>
                                </div>


                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit"
                                            class="btn btn-success w-md m-b-5"
                                            onclick="return confirm('You cannot edit this after sending the email. Are you sure to send the email?') "><?php echo "Send" ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>


            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>
