<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Query_model extends CI_Model
{
    public function get_employ_detail($email){
       return $this->db->select('*')
        ->from('employee_history')
        ->where('email', $email)
        ->get()
        ->result();
    }
    public function get_user_detail($email){
        return $this->db->select('*')
            ->from('user')
            ->where('email', $email)
            ->get()
            ->result();
    }

    public function get_sup_email($id){
        return $this->db->select('email')
            ->from('employee_history')
            ->where('employee_id', $id)
            ->get()
            ->result();
    }

    public function create_query($data){
        $this->db->insert('employee_query', $data);
        return true;
    }
    public function get_query($id){
//        return $this->db->select('*')
//            ->from('employee_query')
//            ->where('id', $id)
//            ->get()
//            ->result();
//        return true;
        $this->db->where('id', $id);
        $query = $this->db->get('employee_query');
        return $query->row();
    }
    public function get_all_query(){
        return $this->db->select('*')
            ->from('employee_query')
            ->get()
            ->result();
    }
    public function get_query_detail_self($id){
        return $this->db->select('*')
            ->from('employee_query')
            ->where('employee_id', $id)
            ->order_by('id', 'DESC')
            ->get()
            ->result();
    }
//    public function get_query_detail($supervisor){
//        return $this->db->select('employee_query.*,employee_history.*')
//            ->from('employee_query')
//            ->join('employee_history', 'employee_history.employee_id = employee_query.employee_id')
//            ->where('supervisor_id', $supervisor)
//            ->get()
//            ->result();
//    }

    public function get_query_detail($emp_id)
    {
        return $this->db->select('employee_query.*,employee_history.*')
            ->from('employee_query')
            ->join('employee_history', 'employee_history.employee_id = employee_query.employee_id')
            ->where(' employee_query.employee_id IN (select employee_id from employee_history where  super_visor_id = '.$emp_id.')',NULL,FALSE)
            ->order_by('id', 'DESC')
            ->get()
            ->result();
    }

//    public function get_query_detail_hr($emp_id){
//        return $this->db->select('employee_query.*,employee_history.*')
//            ->from('employee_query')
//            ->join('employee_history', 'employee_history.employee_id = employee_query.employee_id')
////            ->where('supervisor_id', $emp_id)
//            ->where('approve_by_supervisor !=', null)
//            ->order_by('id', 'DESC')
//            ->get()
//            ->result();
//    }
    public function get_query_detail_hr($emp_id){
        return $this->db->select('t1.*,t2.*,(SELECT CONCAT (t3.first_name," ",t3.last_name) FROM 
                                employee_history as t3 where t3.employee_id = t2.supervisor_id) AS supervisor_name')
            ->from('employee_history as t1 , employee_query as t2')
            ->where('t1.employee_id = t2.employee_id')
            ->where('approve_by_supervisor',2)
            ->order_by('id', 'DESC')
            ->get()
            ->result();
    }
    public function update_query_supervisor($data){
        return $this->db->where('id' , $data['id'])
            ->update('employee_query', $data);
    }
    public function get_query_employee_email($qid){
        return $this->db->select('email')
            ->from('employee_history , employee_query')
            ->where('employee_history.employee_id = employee_query.employee_id')
            ->where('employee_query.id', $qid)
            ->get()
            ->result();
    }
    public function get_query_supervisor_email($qid){
        return $this->db->select('email')
            ->from('employee_history , employee_query')
            ->where('employee_history.employee_id = employee_query.supervisor_id')
            ->where('employee_query.id', $qid)
            ->get()
            ->result();
    }
}
