<?php
$current_date = date("Y-m-d");
$current_time = strtotime($current_date);
?>

<div class="row">
    <div class="col-sm-12">
        <div class="panel-title bulk_add_emp_btn float-right">
            <button type="button" class="btn btn-success btn-md" data-toggle="modal" data-target="#myModal">Add Bulk
                Employees
            </button>
        </div>

        <div class="Alert hide">
            <span class="fa fa-check-circle"></span>
            <span class="msg">Updated Successfully</span>
            <div class="close-btn">
                <span class="fa fa-times"></span>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="myModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title">Add Employees</h4>
                    </div>
                    <div class="modal-body">
                        <?php echo form_open_multipart('employee/Employees/bulk_import_csv', array('class' => 'form-vertical', 'id' => 'validate', 'name' => 'insert_employee')) ?>
                        <input type="file" name="upload_csv_file" id="empfile" required><br><br>
                        <p><a href="<?php echo base_url('assets/files/employees.csv') ?>">Click here to download the
                                sample file</a></p>
                        <p><b>Note:</b> <span class="text-danger">Employee file data format must be as given sample file.</span>
                        </p><br>
                        <input type="submit" name="submit" value="UPLOAD" class="btn btn-success">
                        <?php echo form_close() ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<div class="row employee_listing">
    <!--  table area -->
    <div class="col-sm-12">

        <div class="panel panel-bd">

            <div class="panel-body table-responsive">
                <table width="100%" class="datatable table table-striped table-bordered table-hover">
                    <thead>
                    <tr>
                        <th><?php echo display('employee_id') ?></th>
                        <th><?php echo display('first_name') ?></th>
                        <th><?php echo display('last_name') ?></th>
                        <th><?php echo display('position') ?></th>
                        <th><?php echo "Status" ?></th>
                        <th><?php echo display('action') ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (!empty($emp_history)) { ?>
                        <?php $sl = 1; ?>
                        <?php foreach ($emp_history as $row) {
                            $probation_date = $row->original_hire_date;
                            $probation_time = strtotime($probation_date);
                            if ($row->warning == 0 || $row->warning == null) {
                                $warning = 0;
                            } else {
                                $warning = $row->warning;
                            }
                            ?>
                            <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                <td><?php echo $row->employee_id; ?></td>
                                <td><?php echo $row->first_name; ?></td>
                                <td><?php echo $row->last_name; ?></td>
                                <td><?php echo $row->position_name; ?></td>
                                <td class="emp_status_option">
                                    <select onchange="change_employee_status(this, <?php echo $row->employee_id ?>)"
                                            class="form-control" name="employee_status" id="employee_status_quick">
                                        <option value="">Select Status</option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "4" ? 'selected' : '' : '' ?>
                                                value="4">Cancelled
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "3" ? 'selected' : '' : '' ?>
                                                value="3">Not Started
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "2" ? 'selected' : '' : '' ?>
                                                value="2">On Leave
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "1" ? 'selected' : '' : '' ?>
                                                value="1">Active
                                        </option>
                                        <option <?php echo isset($row->employee_status) ? $row->employee_status == "0" ? 'selected' : '' : '' ?>
                                                value="0">Inactive
                                        </option>
                                    </select>
                                </td>
                                <td class="center">
                                    <?php if ($this->permission->method('employee', 'update')->access()): ?>
                                        <a href="<?php echo base_url("employee/Employees/update_employee_form/$row->employee_id") ?>"
                                           class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>
                                    <?php endif; ?>
                                    <?php if ($this->permission->method('employee', 'delete')->access()): ?>
                                        <a href="<?php echo base_url("employee/Employees/delete_employhistory/$row->employee_id") ?>"
                                           class="btn btn-xs btn-danger"
                                           onclick="return confirm('<?php echo display('are_you_sure') ?>') "><i
                                                    class="fa fa-trash"></i></a>
                                    <?php endif; ?>
                                    <a href="<?php echo base_url("employee/Employees/cv/$row->employee_id"); ?>"
                                       class="btn btn-default btn-xs"><i class="fa fa-user"></i></a>

                                    <?php
                                    if ($row->terminate == 1) { ?>
                                        <em style="color: red">Terminated</em>
                                    <?php } else { ?>
                                        <!-- Confirmation and termination -->
                                        <select name="" id="" class="my-select"
                                                onchange="myFunction(<?php echo $row->employee_id ?>,<?php echo $row->rate ?>,<?php echo $warning ?>,<?php echo $row->pos_id ?>,'<?php echo $row->position_name ?>',this,'<?php echo $row->first_name ?>' , '<?php echo $row->last_name ?>' , '<?php echo $row->email ?>' )">
                                            <option value="0" selected disabled hidden>Choose here</option>
                                            <?php
                                            if ($probation_time > $current_time) { ?>
                                                <option value="1">Confirmation</option>
                                            <?php }
                                            ?>
                                            <option value="2">Warning</option>
                                            <option value="3">Terminate</option>
                                        </select>
                                    <?php }
                                    ?>


                                </td>
                            </tr>
                            <?php $sl++; ?>
                        <?php } ?>
                    <?php } ?>
                    </tbody>
                </table>  <!-- /.table-responsive -->
            </div>
        </div>
    </div>
</div>

<!-- Edit Form Start -->
<div class="row">
    <div class="empform">
        <ul class="nav nav-tabs" id="myTab">
            <li class="active"><a data-toggle="tab" href="#home"><?php echo "Employee Details" ?></a></li>
            <li><a data-toggle="tab" href="#wage"><?php echo "Wage / Position History" ?></a></li>
            <li><a data-toggle="tab" href="#menu1"><?php echo display('positional_info') ?></a></li>
            <li><a data-toggle="tab" href="#probation"><?php echo "Probation" ?></a></li>
            <li><a data-toggle="tab" href="#benefit"><?php echo "Benefit" ?></a></li>
            <li><a data-toggle="tab" href="#vacationtime"><?php echo "Vacation Time" ?></a></li>
            <li><a data-toggle="tab" href="#personaltime"><?php echo "Personal Time" ?></a></li>
            <li><a data-toggle="tab" href="#disciplinaryaction"><?php echo "Disciplinary Action" ?></a></li>
            <li><a data-toggle="tab" href="#qualification">Qualification</a></li>
            <li><a data-toggle="tab" href="#requirements"><?php echo "Requirements" ?></a></li>
            <li><a data-toggle="tab" href="#menu3"><?php echo display('supervisor') ?></a></li>
            <li><a data-toggle="tab" href="#menu4"><?php echo display('biographical_info') ?></a></li>
            <li><a data-toggle="tab" href="#bankinformation"><?php echo "Bank Information" ?></a></li>
            <li><a data-toggle="tab" href="#emergencycontact"><?php echo "Emergency Contact" ?></a></li>
            <li><a data-toggle="tab" href="#menu7"><?php echo display('custom') ?></a></li>
            <li><a data-toggle="tab" href="#menu8"><?php echo display('login_info') ?></a></li>
        </ul>

        <div class="tab-content">
            <div id="home" class="tab-pane fade in active">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                                <?php echo form_open_multipart('employee/Employees/update_employee_form/' . $data->employee_id, 'id="emp_form"') ?>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="first_name"><?php echo display('first_name') ?><sup
                                                        class="color-red ">*</sup></label>

                                            <input id="first_name" name="first_name" type="text" class="form-control"
                                                   placeholder="First Name" value="<?php echo $data->first_name; ?>">
                                            <input type="hidden" name="oldfirstname"
                                                   value="<?php echo $data->first_name; ?>">
                                            <input type="hidden" name="employee_id"
                                                   value="<?php echo $data->employee_id; ?>">

                                        </div>

                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="l_name"><?php echo display('middle_name') ?> </label>
                                            <input type="text" class="form-control" id="middle_name"
                                                   name="middle_name" placeholder="Your Middle Name"
                                                   value="<?php echo $data->middle_name; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="l_name"><?php echo display('last_name') ?></label>

                                            <input type="text" class="form-control" id="last_name"
                                                   name="last_name" placeholder="Your Last Name"
                                                   value="<?php echo $data->last_name; ?>">
                                            <input type="hidden" name="oldlastname"
                                                   value="<?php echo $data->last_name; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="l_name"><?php echo display('maiden_name') ?> </label>
                                            <input type="text" class="form-control" id="maiden_name"
                                                   name="maiden_name" placeholder="Your Maiden Name"
                                                   value="<?php echo $data->maiden_name; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="emp_code">Employee Code<sup
                                                        class="color-red ">*</sup></label>
                                            <input type="text" class="form-control" name="emp_code" id="emp_code"
                                                   value="<?php echo $data->emp_code; ?>" placeholder="Employee Code">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="email"><?php echo display('email') ?> <sup
                                                        class="color-red ">*</sup></label>
                                            <input type="email" class="form-control"
                                                   name="email" id="email" placeholder="Your Email"
                                                   oninput="setuseemail()" value="<?php echo $data->email; ?>">
                                            <span id="email_v_message"></span>

                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="personal_email"><?php echo "Personal Email" ?></label>
                                            <input type="email" class="form-control"
                                                   name="personal_email" id="personal_email"
                                                   placeholder="Employee Personal Email"
                                                   value="<?php echo $data->personal_email; ?>"
                                                   oninput="setuseemail()">
                                            <span id="email_v_message"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="phone"><?php echo display('phone') ?> <sup
                                                        class="color-red ">*</sup></label>
                                            <input type="number" class="form-control" id="phone" name="phone"
                                                   placeholder="Your Phone Number" value="<?php echo $data->phone; ?>">

                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="phone"><?php echo display('alter_phone') ?> <sup
                                                        class="color-red "></sup></label>
                                            <input type="number" class="form-control" name="alter_phone" id="phone"
                                                   value="<?php echo $data->alter_phone; ?>"
                                                   placeholder="Your Phone Number">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="emp_cnic">CNIC<sup
                                                        class="color-red "></sup></label>
                                            <input type="number" class="form-control" name="emp_cnic" id="emp_cnic"
                                                   value="<?php echo $data->emp_cnic; ?>"
                                                   placeholder="Employee CNIC Number">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="state"><?php echo display('state') ?></label>
                                            <?php echo form_dropdown('state', $country_list, (!empty($data->state) ? $data->state : "New York"), ' class="form-control"') ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="city"><?php echo display('city') ?> </label>
                                            <input type="text" class="form-control" id="city"
                                                   name="city" placeholder="City" value="<?php echo $data->city; ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="emp_address"><?php echo "Address" ?></label>
                                            <input type="text" class="form-control" name="emp_address"
                                                   value="<?php echo $data->emp_address; ?>"
                                                   id="emp_address"
                                                   placeholder="Address">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="zip_code"><?php echo display('zip_code') ?></label>
                                            <input type="number" class="form-control" id="zip_code"
                                                   name="zip_code" placeholder="Your Zip Code"
                                                   value="<?php echo $data->zip; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="emp_exp_start_date"><?php echo "Experience Start Date" ?></label>
                                            <input type="month" class="form-control" name="emp_exp_start_date"
                                                   value="<?php echo $data->emp_exp_start_date; ?>"
                                                   id="emp_exp_start_date"
                                                   placeholder="Start Date">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label for="emp_exp_end_date"><?php echo "Experience End Date" ?></label>
                                            <input type="month" class="form-control" name="emp_exp_end_date"
                                                   value="<?php echo $data->emp_exp_end_date; ?>"
                                                   id="emp_exp_end_date"
                                                   placeholder="End Date">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label for="resume"><?php echo "Resume" ?> </label><em style="color: red">
                                                Upload only PDF files</em><br>
                                            <input accept="application/pdf" type="file" class="form-control"
                                                   name="resume" id="resume">
                                            <em class="filename"><a target="_blank" href="<?php echo $data->resume ?>">Download</a></em>
                                            <input type="hidden" name="old_resume" value="<?php echo $data->resume ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="id_card_front"><?php echo "ID Card Front" ?> </label><em style="color: red">
                                                jpg|png|pdf</em><br>
                                            <input accept="application/pdf" type="file" class="form-control"
                                                   name="id_card_front" id="id_card_front">
                                            <em class="filename"><a target="_blank" href="<?php echo $data->id_card_front ?>">Download</a></em>
                                            <input type="hidden" name="old_id_card_front" value="<?php echo $data->id_card_front ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="id_card_back"><?php echo "ID Card Back" ?> </label><em style="color: red">
                                                jpg|png|pdf</em><br>
                                            <input accept="application/pdf" type="file" class="form-control"
                                                   name="id_card_back" id="id_card_back">
                                            <em class="filename"><a target="_blank" href="<?php echo $data->id_card_back ?>">Download</a></em>
                                            <input type="hidden" name="old_id_card_back" value="<?php echo $data->id_card_back ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="signed_nda"><?php echo "Signed NDA" ?> </label><em style="color: red">
                                                Upload PDF Only</em><br>
                                            <input accept="application/pdf" type="file" class="form-control"
                                                   name="signed_nda" id="signed_nda">
                                            <em class="filename"><a target="_blank" href="<?php echo $data->signed_nda ?>">Download</a></em>
                                            <input type="hidden" name="old_signed_nda" value="<?php echo $data->signed_nda ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="signed_offer_letter"><?php echo "Signed Offer Letter" ?> </label><em style="color: red">
                                                Upload PDF Only</em><br>
                                            <input accept="application/pdf" type="file" class="form-control"
                                                   name="signed_offer_letter" id="signed_offer_letter">
                                            <em class="filename"><a target="_blank" href="<?php echo $data->signed_offer_letter ?>">Download</a></em>
                                            <input type="hidden" name="old_signed_offer_letter" value="<?php echo $data->signed_offer_letter ?>">
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group form-group-margin text-right">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf()"
                                           value="NEXT">

                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="qualification" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">
                            <div class="panel-body">
                                <div class="panel panel-default">
                                    <div class="qualification-panel-heading" role="tab" id="headingOne">
                                        <h4 class="qualification-panel-title">
                                            <a role="button" data-toggle="collapse" data-parent="#accordion"
                                               href="#education_tabs" aria-expanded="false" aria-controls="collapseOne"
                                               class="">
                                                Educational Data
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="education_tabs" class="panel-collapse collapse" role="tabpanel"
                                         aria-labelledby="headingOne" aria-expanded="false" style="">
                                        <div class="panel-body">
                                            <div class="panel panel-default">
                                                <div class="qualification-panel-heading" role="tab" id="headingOne">
                                                    <h4 class="qualification-panel-title">
                                                        <a role="button" data-toggle="collapse" data-parent="#accordion"
                                                           href="#masters" aria-expanded="true"
                                                           aria-controls="collapseOne"
                                                           class="">
                                                            Masters
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="masters" class="panel-collapse collapse in" role="tabpanel"
                                                     aria-labelledby="headingOne" aria-expanded="true" style="">
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="masters_degree_title">Degree
                                                                        Title</label>
                                                                    <input id="masters_degree_title"
                                                                           name="masters_degree_title"
                                                                           type="text" class="form-control"
                                                                           placeholder="Title"
                                                                           value="<?php echo $data->masters_degree_title; ?>">
                                                                </div>

                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="masters_majors">Majors</label>
                                                                    <input id="masters_majors" name="masters_majors"
                                                                           type="text"
                                                                           class="form-control"
                                                                           placeholder="Select Major"
                                                                           value="<?php echo $data->masters_majors; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="masters_year_completion">Year
                                                                        Completion</label>
                                                                    <input id="masters_year_completion"
                                                                           name="masters_year_completion" type="text"
                                                                           class="form-control"
                                                                           placeholder="Month/Year"
                                                                           value="<?php echo $data->masters_year_completion; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="masters_institute">Institute</label>
                                                                    <input type="text" class="form-control"
                                                                           id="masters_institute"
                                                                           name="masters_institute"
                                                                           placeholder="Institute"
                                                                           value="<?php echo $data->masters_institute; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="masters_location">Location</label>
                                                                    <input type="text" class="form-control"
                                                                           id="masters_location"
                                                                           name="masters_location"
                                                                           placeholder="Location"
                                                                           value="<?php echo $data->masters_location; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="masters_cgpa">CPGA</label>
                                                                    <input type="text" class="form-control"
                                                                           id="masters_cgpa"
                                                                           name="masters_cgpa" placeholder="CGPA"
                                                                           value="<?php echo $data->masters_cgpa; ?>">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-sm-12">
                                                                <div class="form-group">
                                                                    <label for="master_attachment"><?php echo "Attachment" ?> </label><em
                                                                            style="color: red"> Upload only PDF
                                                                        files</em><br>
                                                                    <input accept="application/pdf" type="file"
                                                                           class="form-control"
                                                                           name="master_attachment"
                                                                           id="master_attachment">
                                                                    <em class="filename"><?php echo $data->master_attachment ?></em>
                                                                    <input type="hidden" name="old_master_attachment"
                                                                           value="<?php echo $data->master_attachment ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel panel-default">
                                                <div class="qualification-panel-heading" role="tab" id="headingTwo">
                                                    <h4 class="qualification-panel-title">
                                                        <a class="collapsed" role="button" data-toggle="collapse"
                                                           data-parent="#accordion" href="#bachelors"
                                                           aria-expanded="false"
                                                           aria-controls="collapseTwo">
                                                            Bachelors
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="bachelors" class="panel-collapse collapse" role="tabpanel"
                                                     aria-labelledby="headingTwo">
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="bachelors_degree_title">Degree
                                                                        Title</label>
                                                                    <input id="bachelors_degree_title"
                                                                           name="bachelors_degree_title"
                                                                           type="text" class="form-control"
                                                                           placeholder="Title"
                                                                           value="<?php echo $data->bachelors_degree_title; ?>">
                                                                </div>

                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="bachelors_majors">Majors</label>
                                                                    <input id="bachelors_majors" name="bachelors_majors"
                                                                           type="text"
                                                                           class="form-control"
                                                                           placeholder="Select Major"
                                                                           value="<?php echo $data->bachelors_majors; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="bachelors_year_completion">Year
                                                                        Completion</label>
                                                                    <input id="bachelors_year_completion"
                                                                           name="bachelors_year_completion" type="text"
                                                                           class="form-control"
                                                                           placeholder="Month/Year"
                                                                           value="<?php echo $data->bachelors_year_completion; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="bachelors_institute">Institute</label>
                                                                    <input type="text" class="form-control"
                                                                           id="bachelors_institute"
                                                                           name="bachelors_institute"
                                                                           placeholder="Institute"
                                                                           value="<?php echo $data->bachelors_institute; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="bachelors_location">Location</label>
                                                                    <input type="text" class="form-control"
                                                                           id="bachelors_location"
                                                                           name="bachelors_location"
                                                                           placeholder="Location"
                                                                           value="<?php echo $data->bachelors_location; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="bachelors_cgpa">CPGA</label>
                                                                    <input type="text" class="form-control"
                                                                           id="bachelors_cgpa"
                                                                           name="bachelors_cgpa" placeholder="CGPA"
                                                                           value="<?php echo $data->bachelors_cgpa; ?>">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-sm-12">
                                                                <div class="form-group">
                                                                    <label for="bachelors_attachment"><?php echo "Attachment" ?> </label><em
                                                                            style="color: red"> Upload only PDF
                                                                        files</em><br>
                                                                    <input accept="application/pdf" type="file"
                                                                           class="form-control"
                                                                           name="bachelors_attachment"
                                                                           id="bachelors_attachment">
                                                                    <em class="filename"><?php echo $data->bachelors_attachment ?></em>
                                                                    <input type="hidden" name="old_bachelors_attachment"
                                                                           value="<?php echo $data->bachelors_attachment ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel panel-default">
                                                <div class="qualification-panel-heading" role="tab" id="headingTwo">
                                                    <h4 class="qualification-panel-title">
                                                        <a class="collapsed" role="button" data-toggle="collapse"
                                                           data-parent="#accordion" href="#inter" aria-expanded="false"
                                                           aria-controls="collapseTwo">
                                                            Intermediate
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="inter" class="panel-collapse collapse" role="tabpanel"
                                                     aria-labelledby="headingTwo">
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="inter_degree_title">Degree Title</label>
                                                                    <input id="inter_degree_title"
                                                                           name="inter_degree_title"
                                                                           type="text" class="form-control"
                                                                           placeholder="Title"
                                                                           value="<?php echo $data->inter_degree_title; ?>">
                                                                </div>

                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="inter_majors">Majors</label>
                                                                    <input id="inter_majors" name="inter_majors"
                                                                           type="text"
                                                                           class="form-control"
                                                                           placeholder="Select Major"
                                                                           value="<?php echo $data->inter_majors; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="inter_year_completion">Year
                                                                        Completion</label>
                                                                    <input id="inter_year_completion"
                                                                           name="inter_year_completion"
                                                                           type="text" class="form-control"
                                                                           placeholder="Month/Year"
                                                                           value="<?php echo $data->inter_year_completion; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="inter_institute">Institute</label>
                                                                    <input type="text" class="form-control"
                                                                           id="inter_institute"
                                                                           name="inter_institute"
                                                                           placeholder="Institute"
                                                                           value="<?php echo $data->inter_institute; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="inter_location">Location</label>
                                                                    <input type="text" class="form-control"
                                                                           id="inter_location"
                                                                           name="inter_location" placeholder="Location"
                                                                           value="<?php echo $data->inter_location; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="inter_percentage">Percentage</label>
                                                                    <input type="text" class="form-control"
                                                                           id="inter_percentage"
                                                                           name="inter_percentage"
                                                                           placeholder="Percentage"
                                                                           value="<?php echo $data->inter_percentage; ?>">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-sm-12">
                                                                <div class="form-group">
                                                                    <label for="inter_attachment"><?php echo "Attachment" ?> </label><em
                                                                            style="color: red"> Upload only PDF
                                                                        files</em><br>
                                                                    <input accept="application/pdf" type="file"
                                                                           class="form-control"
                                                                           name="inter_attachment"
                                                                           id="inter_attachment">
                                                                    <em class="filename"><?php echo $data->inter_attachment ?></em>
                                                                    <input type="hidden" name="old_inter_attachment"
                                                                           value="<?php echo $data->inter_attachment ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="panel panel-default">
                                                <div class="qualification-panel-heading" role="tab" id="headingTwo">
                                                    <h4 class="qualification-panel-title">
                                                        <a class="collapsed" role="button" data-toggle="collapse"
                                                           data-parent="#accordion" href="#matric" aria-expanded="false"
                                                           aria-controls="collapseTwo">
                                                            Matriculation
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="matric" class="panel-collapse collapse" role="tabpanel"
                                                     aria-labelledby="headingTwo">
                                                    <div class="panel-body">
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="matric_degree_title">Degree
                                                                        Title</label>
                                                                    <input id="matric_degree_title"
                                                                           name="matric_degree_title"
                                                                           type="text" class="form-control"
                                                                           placeholder="Title"
                                                                           value="<?php echo $data->matric_degree_title; ?>">
                                                                </div>

                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="matric_majors">Majors</label>
                                                                    <input id="matric_majors" name="matric_majors"
                                                                           type="text"
                                                                           class="form-control"
                                                                           placeholder="Select Major"
                                                                           value="<?php echo $data->matric_majors; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group">
                                                                    <label for="matric_year_completion">Year
                                                                        Completion</label>
                                                                    <input id="matric_year_completion"
                                                                           name="matric_year_completion"
                                                                           type="text" class="form-control"
                                                                           placeholder="Month/Year"
                                                                           value="<?php echo $data->matric_year_completion; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="matric_institute">Institute</label>
                                                                    <input type="text" class="form-control"
                                                                           id="matric_institute"
                                                                           name="matric_institute"
                                                                           placeholder="Institute"
                                                                           value="<?php echo $data->matric_institute; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="matric_location">Location</label>
                                                                    <input type="text" class="form-control"
                                                                           id="matric_location"
                                                                           name="matric_location" placeholder="Location"
                                                                           value="<?php echo $data->matric_location; ?>">
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-4">
                                                                <div class="form-group form-group-margin">
                                                                    <label for="matric_percentage">Percentage</label>
                                                                    <input type="text" class="form-control"
                                                                           id="matric_percentage"
                                                                           name="matric_percentage"
                                                                           placeholder="Percentage"
                                                                           value="<?php echo $data->matric_percentage; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-sm-12">
                                                                <div class="form-group">
                                                                    <label for="matric_attachment"><?php echo "Attachment" ?> </label><em
                                                                            style="color: red"> Upload only PDF
                                                                        files</em><br>
                                                                    <input accept="application/pdf" type="file"
                                                                           class="form-control"
                                                                           name="matric_attachment"
                                                                           id="matric_attachment">
                                                                    <em class="filename"><?php echo $data->matric_attachment ?></em>
                                                                    <input type="hidden" name="old_matric_attachment"
                                                                           value="<?php echo $data->matric_attachment ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="panel panel-default">
                                    <div class="qualification-panel-heading" role="tab" id="headingOne">
                                        <h4 class="qualification-panel-title">
                                            <a role="button" data-toggle="collapse" data-parent="#accordion"
                                               href="#professional_exp_tabs" aria-expanded="false"
                                               aria-controls="collapseOne"
                                               class="">
                                                Professional Experience
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="professional_exp_tabs" class="panel-collapse collapse" role="tabpanel"
                                         aria-labelledby="headingOne" aria-expanded="false" style="">
                                        <div class="panel-body">
                                            <div class="row">
                                                <label for="pf_exp">Professional Experience</label>
                                                <span>
                                        <?php foreach ($documentsinfo as $documents) { ?>

                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name"
                                                       value="<?php echo $documents->p_e_company_name ?>">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date"
                                                      value="<?php echo $documents->p_e_start_date ?>">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date"
                                                      value="<?php echo $documents->p_e_end_date ?>">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                     <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option <?php echo $documents->p_e_skill_name == $list->skill_id ? 'selected' : '' ?> value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation"
                                                               value="<?php echo $documents->p_e_designation ?>">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location"
                                                               value="<?php echo $documents->p_e_location ?>">
                                                      </div>
                                                </div>
                                            </div>

                                        <?php } ?>
                                                    <?php if (empty($documentsinfo)) { ?>
                                                        <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name"
                                                       value="<?php echo $documents->p_e_company_name ?>">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date"
                                                      value="<?php echo $documents->p_e_start_date ?>">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date"
                                                      value="<?php echo $documents->p_e_end_date ?>">
                                              </div>
                                            </div>

                                          </div>

                                                        <div class="row">

                                                                 <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option <?php echo $documents->p_e_skill_name == $list->skill_id ? 'selected' : '' ?> value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation"
                                                               value="<?php echo $documents->p_e_designation ?>">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location"
                                                               value="<?php echo $documents->p_e_location ?>">
                                                      </div>
                                                </div>
                                            </div>
                                                    <?php } ?>
                                    </span>
                                                <!-- #1 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                              <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #2 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                              <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #3 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                            <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #4 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                                 <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #5 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                                 <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #6 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                            <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #7 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                                <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #8 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                                 <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #9 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                               <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #10 -->
                                                <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="p_e_company_name"><?php echo 'Company Name'; ?></label>
                                                <input type="text" class="form-control" id="p_e_company_name"
                                                       name="p_e_company_name[]" placeholder="Company Name">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="p_e_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_start_date"
                                                      name="p_e_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                            <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="p_e_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="p_e_end_date"
                                                      name="p_e_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>
                                               <div class="row">

                                                       <div class="col-sm-4">
                                                    <div class="form-group">
                                                        <label for="skill_name"><?php echo "Skill" ?></label>
                                                        <select name="p_e_skill_name[]" id="skill_name"
                                                                class="form-control">
                                                            <?php
                                                            foreach ($skillslist as $list) { ?>
                                                                <option value="<?php echo $list->skill_id ?>"><?php echo $list->skill_name ?></option>
                                                            <?php }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_designation"><?php echo 'Designation'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_designation"
                                                               name="p_e_designation[]" placeholder="Designation">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-4">
                                                      <div class="form-group">
                                                        <label for="p_e_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="p_e_location"
                                                               name="p_e_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>


                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="panel panel-default">
                                    <div class="qualification-panel-heading" role="tab" id="headingOne">
                                        <h4 class="qualification-panel-title">
                                            <a role="button" data-toggle="collapse" data-parent="#accordion"
                                               href="#certification_tabs" aria-expanded="false"
                                               aria-controls="collapseOne"
                                               class="">
                                                Certification & Trainings
                                            </a>
                                        </h4>
                                    </div>
                                    <div id="certification_tabs" class="panel-collapse collapse" role="tabpanel"
                                         aria-labelledby="headingOne" aria-expanded="false" style="">
                                        <div class="panel-body">
                                            <div class="row">
                                                <label for="pf_exp">Certification & Trainings</label>
                                                <span>
                                        <?php foreach ($certificationsinfo as $certifications) { ?>

                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name"
                                                       value="<?php echo $certifications->c_t_name ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date"
                                                      value="<?php echo $certifications->c_t_start_date ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date"
                                                      value="<?php echo $certifications->c_t_end_date ?>">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute"
                                                               value="<?php echo $certifications->c_t_institute ?>">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location"
                                                               value="<?php echo $certifications->c_t_location ?>">
                                                      </div>
                                                </div>
                                            </div>

                                        <?php } ?>
                                                    <?php if (empty($certificationsinfo)) { ?>
                                                        <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name"
                                                       value="<?php echo $certifications->c_t_name ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date"
                                                      value="<?php echo $certifications->c_t_start_date ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date"
                                                      value="<?php echo $certifications->c_t_end_date ?>">
                                              </div>
                                            </div>

                                          </div>

                                                        <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute"
                                                               value="<?php echo $certifications->c_t_institute ?>">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location"
                                                               value="<?php echo $certifications->c_t_location ?>">
                                                      </div>
                                                </div>
                                            </div>
                                                    <?php } ?>
                                    </span>
                                                <!-- #1 -->
                                                <div id="add" class="toggle">
                                          <span>
                                          <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #2 -->
                                                <div id="add" class="toggle">
                                          <span>
                                        <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #3 -->
                                                <div id="add" class="toggle">
                                          <span>
                                        <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #4 -->
                                                <div id="add" class="toggle">
                                          <span>
                                       <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #5 -->
                                                <div id="add" class="toggle">
                                          <span>
                                    <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #6 -->
                                                <div id="add" class="toggle">
                                          <span>
                                          <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #7 -->
                                                <div id="add" class="toggle">
                                          <span>
                                        <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #8 -->
                                                <div id="add" class="toggle">
                                          <span>
                                              <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #9 -->
                                                <div id="add" class="toggle">
                                          <span>
                                                <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>

                                                <!-- #10 -->
                                                <div id="add" class="toggle">
                                          <span>
                                             <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="c_t_name"><?php echo 'Certification Name'; ?></label>
                                                <input type="text" class="form-control" id="c_t_name"
                                                       name="c_t_name[]" placeholder="Certification Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="c_t_start_date"><?php echo 'Start Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_start_date"
                                                      name="c_t_start_date[]" placeholder="Start Date">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="c_t_end_date"><?php echo 'End Date'; ?></label>
                                               <input type="month" class="form-control" id="c_t_end_date"
                                                      name="c_t_end_date[]" placeholder="End Date">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_institute"><?php echo 'Institute'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_institute"
                                                               name="c_t_institute[]" placeholder="Institute">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="c_t_location"><?php echo 'Location'; ?></label>
                                                        <input type="text" class="form-control" id="c_t_location"
                                                               name="c_t_location[]" placeholder="Location">
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                                </div>


                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="form-group form-group-margin text-right">
                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf()"
                                       value="NEXT">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="menu1" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="dept_id"><?php echo "Department"; ?> <sup
                                                        class="color-red ">*</sup></label><br>
                                            <select name="division" id="division" class="form-control">
                                                <option value=""> Select Department</option>
                                                <?php
                                                //                                                foreach ($dropdowndept as $dpts) {
                                                //                                                    echo '<option value="' . $dpts['dept_id'] . '">' . $dpts['department_name'] . '</option>';
                                                //                                                }
                                                ?>

                                                <?php foreach ($dropdowndept as $dpts) { ?>
                                                    <option value="<?php echo $dpts['dept_id'] ?>" <?php if ($data->dept_id == $dpts['dept_id']) {
                                                        echo 'selected';
                                                    } ?>><?php echo $dpts['department_name']; ?></option>
                                                <?php } ?>
                                            </select>
                                            <span id="divis"></span>

                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="designation"><?php echo display('designation'); ?> <sup
                                                        class="color-red ">*</sup></label>

                                            <select name="pos_id" id="designation" class="form-control">
                                                <option value="">select Designation</option>
                                                <?php foreach ($designation as $desig) { ?>
                                                    <option value="<?php echo $desig->pos_id ?>" <?php if ($data->pos_id == $desig->pos_id) {
                                                        echo 'selected';
                                                    } ?>><?php echo $desig->position_name; ?></option>
                                                <?php } ?>
                                            </select>
                                            <span id="desig"></span>
                                        </div>
                                    </div>


                                </div>
                                <div class="row">

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="period"><?php echo display('duty_type') ?></label><br>
                                            <select name="duty_type" class="form-control">
                                                <option value="1" <?php if ($data->duty_type == 1) {
                                                    echo 'selected';
                                                } ?>> Intern
                                                </option>
                                                <option value="2" <?php if ($data->duty_type == 2) {
                                                    echo 'selected';
                                                } ?>> Full Time
                                                </option>
                                                <option value="3" <?php if ($data->duty_type == 3) {
                                                    echo 'selected';
                                                } ?>> Part Time
                                                </option>
                                                <option value="4" <?php if ($data->duty_type == 4) {
                                                    echo 'selected';
                                                } ?>> Contructual
                                                </option>
                                                <option value="5" <?php if ($data->duty_type == 5) {
                                                    echo 'selected';
                                                } ?>> Other
                                                </option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo "Joining Date" ?> <sup
                                                        class="color-red ">*</sup></label>
                                            <input type="text" class="form-control datepicker"
                                                   name="hiredate" id="hiredate" placeholder="Joining Date"
                                                   value="<?php echo $data->hire_date ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="work_hour"><?php echo "Probation Date" ?> <sup
                                                        class="color-red ">*</sup></label>

                                            <input type="text" class="form-control datepicker"
                                                   name="ohiredate" id="ohiredate" placeholder="Probation Date"
                                                   value="<?php echo $data->original_hire_date ?>">

                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo "Organization Leaving Date " ?> </label>
                                            <input type="text" class="form-control datepicker"
                                                   name="terminatedate" id="tdate"
                                                   placeholder="Organization Leaving Date "
                                                   value="<?php echo $data->termination_date ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="work_hour"><?php echo "Reason For Leaving " ?> </label>
                                            <textarea class="form-control"
                                                      name="termreason" id="treason"
                                                      placeholder="Reason For Leaving"><?php echo $data->termination_reason ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="period"><?php echo "Leaving Type" ?></label>
                                            <select name="volunt_termination" class="form-control">
                                                <option value=""><?php echo display('select') ?></option>
                                                <option value="1" <?php if ($data->voluntary_termination == 1) {
                                                    echo 'selected';
                                                } ?>> Resignation
                                                </option>
                                                <option value="2" <?php if ($data->voluntary_termination == 2) {
                                                    echo 'selected';
                                                } ?>>Termination
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo display('re_hire_date') ?> </label>
                                            <input type="text" class="form-control datepicker"
                                                   name="rehiredate" id="rhdate" placeholder="Rehire date"
                                                   value="<?php echo $data->rehire_date ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="period"><?php echo "Payment Mode" ?> <sup
                                                        class="color-red ">*</sup></label>

                                            <select name="rate_type" id="rate_type" class="form-control">
                                                <option value="1" <?php if ($data->rate_type == 1) {
                                                    echo 'selected';
                                                } ?>>Wages
                                                </option>
                                                <option value="2" <?php if ($data->rate_type == 2) {
                                                    echo 'selected';
                                                } ?>>Salary
                                                </option>
                                            </select>
                                            <span id="rat_tp"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo "Amount" ?><sup
                                                        class="color-red ">*</sup></label>
                                            <input type="number" class="form-control"
                                                   name="rate" id="rate" placeholder="<?php echo "Amount" ?>"
                                                   value="<?php echo $data->rate; ?>">

                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="period"><?php echo display('pay_frequency') ?> <sup
                                                        class="color-red ">*</sup></label><br>
                                            <select name="pay_frequency" id="pay_frequency" class="form-control">
                                                <option value="">Select Frequency</option>
                                                <option value="1" <?php if ($data->pay_frequency == 1) {
                                                    echo 'selected';
                                                } ?>>Weekly
                                                </option>
                                                <option value="2" <?php if ($data->pay_frequency == 2) {
                                                    echo 'selected';
                                                } ?>>Biweekly
                                                </option>
                                                <option value="4" <?php if ($data->pay_frequency == 4) {
                                                    echo 'selected';
                                                } ?>>Monthly
                                                </option>
                                                <option value="3" <?php if ($data->pay_frequency == 3) {
                                                    echo 'selected';
                                                } ?>>Annual
                                                </option>

                                            </select>
                                            <span id="frequ"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo display('pay_frequency_txt') ?></label>
                                            <input type="text" class="form-control"
                                                   name="pay_f_text" id="qfre_text" placeholder="Paym Frequency text"
                                                   value="<?php echo $data->pay_frequency_txt; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="work_hour"><?php echo display('hourly_rate2') ?></label>
                                            <input type="number" class="form-control"
                                                   name="h_rate2" id="rate2" placeholder="Hourly Rate"
                                                   value="<?php echo $data->hourly_rate2; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo display('hourly_rate3') ?></label>
                                            <input type="number" class="form-control"
                                                   name="h_rate3" id="rate3" placeholder="Hourly Rate"
                                                   value="<?php echo $data->hourly_rate3; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="work_hour"><?php echo display('home_department') ?></label>
                                            <input type="text" class="form-control"
                                                   name="h_department" id="rate3" placeholder="Hourly Rate"
                                                   value="<?php echo $data->home_department; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="work_hour"><?php echo display('department_text') ?></label>
                                            <input type="text" class="form-control"
                                                   name="h_dep_text" id="hdptext" placeholder="Hourly Rate"
                                                   value="<?php echo $data->department_text; ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="shift_start"><?php echo "Shift Start" ?></label>
                                            <input type="time" class="form-control"
                                                   name="shift_start" id="shift_start" placeholder="Shift Start"
                                                   value="<?php echo $data->shift_start; ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="shift_end"><?php echo "Shift End" ?></label>
                                            <input type="time" class="form-control"
                                                   name="shift_end" id="shift_end" placeholder="Shift End"
                                                   value="<?php echo $data->shift_end; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group form-group-margin text-right">
                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf2()"
                                       value="NEXT">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="probation" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="probation_start_date"><?php echo "Start Date" ?></label>
                                            <input type="date" class="form-control" id="probation_start_date"
                                                   name="probation_start_date"
                                                   placeholder="<?php echo "Start Date" ?>"
                                                   value="<?php echo $data->probation_start_date ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="probation_end_date"><?php echo "Probation End Date" ?></label>
                                            <input type="date" class="form-control" id="probation_end_date"
                                                   name="probation_end_date"
                                                   placeholder="<?php echo "Probation End Date" ?>"
                                                   value="<?php echo $data->probation_end_date ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="evaluation_by"><?php echo "Evaluation By" ?></label>
                                            <select name="evaluation_by" class="form-control">
                                                <option value="">Select One</option>
                                                <?php foreach ($emplist as $emp) { ?>
                                                    <option value="<?php echo $emp->employee_id ?>" <?php if ($data->evaluation_by == $emp->employee_id) {
                                                        echo 'selected';
                                                    } ?>><?php echo $emp->first_name . ' ' . $emp->last_name ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="probation_status"><?php echo "Probation Status" ?></label>
                                            <select class="form-control" name="probation_status" id="probation_status">
                                                <option <?php echo $data->probation_status == 1 ? 'selected' : '' ?>
                                                        value="1">Extended
                                                </option>
                                                <option <?php echo $data->probation_status == 2 ? 'selected' : '' ?>
                                                        value="2">Successfully Completed
                                                </option>
                                                <option <?php echo $data->probation_status == 3 ? 'selected' : '' ?>
                                                        value="3">In Progress
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <div class="form-group form-group-margin">
                                            <label for="evaluation_status"><?php echo "Evaluation Status" ?></label>
                                            <textarea class="form-control" name="evaluation_status"
                                                      id="evaluation_status"><?php echo $data->evaluation_status ?></textarea>
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">

                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf_bankInfo()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="vacationtime" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="mr-25">
                                        <table id="vacation_record_table" width="100%"
                                               class="table table-striped table-bordered table-hover">
                                            <thead>
                                            <tr>
                                                <th><?php echo "S.No" ?></th>
                                                <th><?php echo "Date" ?></th>
                                                <th><?php echo "V. Time (hours)" ?></th>
                                                <th><?php echo "Description" ?></th>
                                                <th><?php echo display('action') ?></th>
                                            </tr>
                                            </thead>

                                        </table>  <!-- /.table-responsive -->
                                        <button type="button" class="btn btn-primary btn-md" data-target="#vacationadd"
                                                data-toggle="modal"><i class="fa fa-plus-circle" aria-hidden="true"></i>
                                            <?php echo "Add Vacation Time" ?></button>
                                    </div>

                                </div>


                            </div>


                            <div class="form-group form-group-margin text-right">

                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf3()"
                                       value="NEXT">
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div id="personaltime" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="mr-25">
                                        <table id="personal_record_table" width="100%"
                                               class="table table-striped table-bordered table-hover">
                                            <thead>
                                            <tr>
                                                <th><?php echo "S.No" ?></th>
                                                <th><?php echo "Date" ?></th>
                                                <th><?php echo "P. Time (hours)" ?></th>
                                                <th><?php echo "Description" ?></th>
                                                <th><?php echo display('action') ?></th>
                                            </tr>
                                            </thead>

                                        </table>  <!-- /.table-responsive -->
                                        <button type="button" class="btn btn-primary btn-md" data-target="#personaladd"
                                                data-toggle="modal"><i class="fa fa-plus-circle" aria-hidden="true"></i>
                                            <?php echo "Add Personal Time" ?></button>
                                    </div>

                                </div>


                            </div>


                            <div class="form-group form-group-margin text-right">

                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf3()"
                                       value="NEXT">
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div id="disciplinaryaction" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="mr-25">
                                        <table id="disciplinary_record_table" width="100%"
                                               class="table table-striped table-bordered table-hover">
                                            <thead>
                                            <tr>
                                                <th><?php echo "S.No" ?></th>
                                                <th><?php echo "Action Date" ?></th>
                                                <th><?php echo "Comments" ?></th>
                                                <th><?php echo display('action') ?></th>
                                            </tr>
                                            </thead>

                                        </table>  <!-- /.table-responsive -->
                                        <button type="button" class="btn btn-primary btn-md"
                                                data-target="#disciplinaryadd"
                                                data-toggle="modal"><i class="fa fa-plus-circle" aria-hidden="true"></i>
                                            <?php echo "Add Diciplinary Action Record" ?></button>
                                    </div>

                                </div>


                            </div>


                            <div class="form-group form-group-margin text-right">

                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf3()"
                                       value="NEXT">
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div id="wage" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="mr-25">
                                        <table id="wage_record_table" width="100%"
                                               class="table table-striped table-bordered table-hover">
                                            <thead>
                                            <tr>
                                                <th><?php echo "S.No" ?></th>
                                                <th><?php echo "Start Date" ?></th>
                                                <th><?php echo "End Date" ?></th>
                                                <th><?php echo "Job Title" ?></th>
                                                <th><?php echo "Department" ?></th>
                                                <th><?php echo "Wage" ?></th>
                                                <th><?php echo "Band" ?></th>
                                                <th><?php echo "Step" ?></th>
                                                <th><?php echo display('action') ?></th>
                                            </tr>
                                            </thead>

                                        </table>  <!-- /.table-responsive -->
                                        <button type="button" class="btn btn-primary btn-md" data-target="#wageadd"
                                                data-toggle="modal"><i class="fa fa-plus-circle" aria-hidden="true"></i>
                                            <?php echo "Add Job History Record" ?></button>
                                    </div>

                                </div>


                            </div>


                            <div class="form-group form-group-margin text-right">

                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf3()"
                                       value="NEXT">
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div id="benefit" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="benefit_name"><?php echo "Benefit Name" ?></label>
                                            <select name="benefit_name[]" id="benefit_name" class="form-control"
                                                    multiple="multiple">
                                                <?php
                                                foreach ($benefitlist as $list) { ?>
                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                <?php }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="emp_grade"><?php echo "Employee Grade" ?></label>
                                            <select class="form-control" name="emp_grade" id="emp_grade">
                                                <option value="">Select Grade</option>
                                                <option <?php echo isset($data->emp_grade) ? $data->emp_grade == "A" ? 'selected' : '' : '' ?>
                                                        value="A">Grade A
                                                </option>
                                                <option <?php echo isset($data->emp_grade) ? $data->emp_grade == "B" ? 'selected' : '' : '' ?>
                                                        value="B">Grade B
                                                </option>
                                                <option <?php echo isset($data->emp_grade) ? $data->emp_grade == "C" ? 'selected' : '' : '' ?>
                                                        value="C">Grade C
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="benefit_accural_date"><?php echo "Benefit Accrual Date" ?></label>
                                            <input type="date" class="form-control" name="benefit_accural_date"
                                                   value="<?php echo $data->benefit_accural_date ?>"
                                                   id="benefit_accural_date">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-sm-6">
                                            <label for="benefit_status"><?php echo "Benefit Status" ?></label>
                                            <select class="form-control" name="benefit_status" id="benefit_status">
                                                <option value="">Select Status</option>
                                                <option <?php echo isset($data->benefit_status) ? $data->benefit_status == "1" ? 'selected' : '' : '' ?>
                                                        value="1">Active
                                                </option>
                                                <option <?php echo isset($data->benefit_status) ? $data->benefit_status == "0" ? 'selected' : '' : '' ?>
                                                        value="0">Inactive
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <label for="dependent">Dependent</label>
                                    <span>
                                        <?php foreach ($dependentsinfo as $dependents) { ?>

                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name"
                                                       value="<?php echo $dependents->dependent_name ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation"
                                                      value="<?php echo $dependents->dependent_relation ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC"
                                                      value="<?php echo $dependents->dependent_cnic ?>">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth"
                                                               value="<?php echo $dependents->dependent_dob ?>">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                            <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control multi-selector-depents"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>

                                        <?php } ?>
                                        <?php if (empty($dependentsinfo)) { ?>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name"
                                                       value="<?php echo $dependents->dependent_name ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation"
                                                      value="<?php echo $dependents->dependent_relation ?>">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC"
                                                      value="<?php echo $dependents->dependent_cnic ?>">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth"
                                                               value="<?php echo $dependents->dependent_dob ?>">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </span>
                                    <!-- #1 -->
                                    <div id="add" class="toggle">
                                          <span>
                                                <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #2 -->
                                    <div id="add" class="toggle">
                                          <span>
                                           <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                       <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #3 -->
                                    <div id="add" class="toggle">
                                          <span>
                                           <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #4 -->
                                    <div id="add" class="toggle">
                                          <span>
                                           <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #5 -->
                                    <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                    <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #6 -->
                                    <div id="add" class="toggle">
                                          <span>
                                             <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #7 -->
                                    <div id="add" class="toggle">
                                          <span>
                                                <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #8 -->
                                    <div id="add" class="toggle">
                                          <span>
                                       <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #9 -->
                                    <div id="add" class="toggle">
                                          <span>
                                            <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>

                                    <!-- #10 -->
                                    <div id="add" class="toggle">
                                          <span>
                                      <div class="row">
                                            <div class="col-sm-4">
                                              <div class="form-group">
                                                <label for="dependent_name"><?php echo 'Name'; ?></label>
                                                <input type="text" class="form-control" id="dependent_name"
                                                       name="dependent_name[]" placeholder="Name">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-margin">
                                                <label for="dependent_relation"><?php echo 'Relation'; ?></label>
                                               <input type="text" class="form-control" id="dependent_relation"
                                                      name="dependent_relation[]" placeholder="Relation">
                                              </div>
                                            </div>

                                                <div class="col-sm-4">
                                              <div class="form-group form-group-new form-group-margin-left">
                                               <label for="dependent_cnic"><?php echo 'CNIC'; ?></label>
                                               <input type="text" class="form-control" id="dependent_cnic"
                                                      name="dependent_cnic[]" placeholder="CNIC">
                                              </div>
                                            </div>

                                          </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_dob"><?php echo 'Date of Birth'; ?></label>
                                                        <input type="date" class="form-control" id="dependent_dob"
                                                               name="dependent_dob[]" placeholder="Date of Birth">
                                                      </div>
                                                </div>

                                                 <div class="col-sm-6">
                                                      <div class="form-group">
                                                        <label for="dependent_benefit"><?php echo "Benefit Name" ?></label>
                                                          <input type="hidden" value="" name="dependent_benefit[]">
                                                            <select name="dependent_benefits[]" id="dependent_benefits"
                                                                    class="form-control"
                                                                    multiple="multiple">
                                                                <?php
                                                                foreach ($benefitlist as $list) { ?>
                                                                    <option value="<?php echo $list->benefit_id ?>"><?php echo $list->benefit_name ?></option>
                                                                <?php }
                                                                ?>
                                                            </select>
                                                      </div>
                                                </div>
                                            </div>
                                          </span>
                                    </div>


                                </div>

                            </div>


                            <div class="form-group form-group-margin text-right">

                                <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                <input type="button" class="btn btn-primary btnNext" onclick="valid_inf3()"
                                       value="NEXT">
                            </div>


                        </div>
                    </div>
                </div>
            </div>

            <div id="menu3" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="col-sm-6" style="display: none">
                                        <div class="form-group">
                                            <label for="s_name"><?php echo display('super_visor_name') ?></label>
                                            <select name="supervisorname" class="form-control">
                                                <option value="">Select One</option>
                                                <option value="self" <?php if ($data->super_visor_id == 'self') {
                                                    echo 'selected';
                                                } ?>>Self
                                                </option>
                                                <?php foreach ($emplist as $emp) { ?>
                                                    <option value="<?php echo $emp->employee_id ?>" <?php if ($data->super_visor_id == $emp->employee_id) {
                                                        echo 'selected';
                                                    } ?>><?php echo $emp->first_name . ' ' . $emp->last_name ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="l_name">Department Line Manager</label>
                                            <select name="is_manager" class="form-control">
                                                <option value="0" <?php if ($data->is_manager == 0) {
                                                    echo 'selected';
                                                } ?>>No
                                                </option>
                                                <option value="1" <?php if ($data->is_manager == 1) {
                                                    echo 'selected';
                                                } ?>>Yes
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 supervisor_report">
                                        <div class="form-group">
                                            <label for="reports"><?php echo "Supervisor Comments" ?> </label>
                                            <input type="text" class="form-control" id="benifit_acc_date"
                                                   name="reports" placeholder="Comments"
                                                   value="<?php echo $data->supervisor_report; ?>">
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">

                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf4()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="menu4" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="s_name"><?php echo display('dob') ?><sup
                                                        class="color-red ">*</sup></label>
                                            <input type="text" class="form-control datepicker" id="dob"
                                                   name="dob" placeholder="Date Of Birth"
                                                   value="<?php echo $data->dob; ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="gender"><?php echo display('gender') ?><sup
                                                        class="color-red ">*</sup></label>
                                            <select name="gender" id="gender" class="form-control">
                                                <option value="1" <?php if ($data->gender == 1) {
                                                    echo 'selected';
                                                } ?>>Male
                                                </option>
                                                <option value="2" <?php if ($data->gender == 2) {
                                                    echo 'selected';
                                                } ?>>Female
                                                </option>
                                                <option value="2" <?php if ($data->gender == 3) {
                                                    echo 'selected';
                                                } ?>>Other
                                                </option>
                                            </select>
                                            <span id="gend"></span>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="reports"><?php echo display('marital_stats') ?> </label>
                                            <select name="marital_status" class="form-control">
                                                <option value="1" <?php if ($data->marital_status == 1) {
                                                    echo 'selected';
                                                } ?>>Single
                                                </option>
                                                <option value="2" <?php if ($data->marital_status == 2) {
                                                    echo 'selected';
                                                } ?>>Married
                                                </option>
                                                <option value="3" <?php if ($data->marital_status == 3) {
                                                    echo 'selected';
                                                } ?>>Divorced
                                                </option>
                                                <option value="4" <?php if ($data->marital_status == 4) {
                                                    echo 'selected';
                                                } ?>>Widowed
                                                </option>
                                                <option value="5" <?php if ($data->marital_status == 5) {
                                                    echo 'selected';
                                                } ?>>Other
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="s_name"><?php echo "Religion" ?></label>
                                            <input type="text" class="form-control" id="ethnic"
                                                   name="ethnic" placeholder="Religion"
                                                   value="<?php echo $data->ethnic_group; ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="ssn"><?php echo display('ssn') ?></label>
                                            <input type="text" class="form-control" id="ssn"
                                                   name="ssn" placeholder="SSN" value="<?php echo $data->ssn; ?>">

                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="w_s"><?php echo "Work In" ?></label>
                                            <?php echo form_dropdown('w_s', $country_list, (!empty($data->work_in_state) ? $data->work_in_state : "New York"), ' class="form-control"') ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="l_in_s"><?php echo "Live In" ?></label>
                                            <?php echo form_dropdown('l_in_s', $country_list, (!empty($data->live_in_state) ? $data->live_in_state : "New York"), ' class="form-control"') ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="citizenship"><?php echo display('citizenship') ?></label>
                                            <?php echo form_dropdown('citizenship', $country_list, (!empty($data->citizenship) ? $data->citizenship : "New York"), ' class="form-control"') ?>
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="picture"><?php echo display('picture') ?></label>
                                        <input type="file" accept="image/*" name="picture" onchange="loadFile(event)">
                                        <small id="fileHelp" class="text-muted"><img src="<?php if ($data->picture) {
                                                echo base_url() . $data->picture;
                                            } else {
                                                echo base_url() . 'assets/img/user/default.jpg';
                                            } ?>" id="output" class="img-thumbnail img-preview"/>
                                        </small>
                                        <input type="hidden" name="old_image" value="<?php echo $data->picture; ?>">
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">

                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf5()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="bankinformation" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                                <div class="row">

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="account_title"><?php echo "Account Title" ?></label>
                                            <input type="text" class="form-control" id="account_title"
                                                   name="account_title"
                                                   placeholder="<?php echo "Account Title" ?>"
                                                   value="<?php echo $data->account_title ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="bank_name"><?php echo "Bank Name" ?></label>
                                            <input type="text" class="form-control" id="bank_name"
                                                   name="bank_name"
                                                   placeholder="<?php echo "Bank Name" ?>"
                                                   value="<?php echo $data->bank_name ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="account_number"><?php echo "Account Number" ?></label>
                                            <input type="number" class="form-control" id="account_number"
                                                   name="account_number"
                                                   placeholder="<?php echo "Account Number" ?>"
                                                   value="<?php echo $data->account_number ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group form-group-margin">
                                            <label for="iban_number"><?php echo "IBAN Number" ?></label>
                                            <input type="text" class="form-control" id="iban_number"
                                                   name="iban_number"
                                                   placeholder="<?php echo "IBAN Number" ?>"
                                                   value="<?php echo $data->iban_number ?>">
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">

                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf_bankInfo()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="requirements" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                                <div class="row">
                                    <table width="100%" class="table table-striped table-bordered table-hover">
                                        <thead>
                                        <tr>
                                            <th><?php echo "Requirements" ?></th>
                                            <th><?php echo "Check" ?></th>
                                            <th><?php echo "Date Received" ?></th>
                                            <th><?php echo "Attachment" ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>Diploma</td>
                                            <td><input <?php echo $data->req_diploma_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox" name="req_diploma_check">
                                            </td>
                                            <td><input class="form-control" type="date" name="req_diploma_date"
                                                       value="<?php echo $data->req_diploma_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_diploma_file">
                                                <em><a target="_blank" href="<?php echo $data->req_diploma_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_diploma_file"
                                                   value="<?php echo $data->req_diploma_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>NBI</td>
                                            <td><input <?php echo $data->req_nbi_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox" name="req_nbi_check"></td>
                                            <td><input class="form-control" type="date" name="req_nbi_date"
                                                       value="<?php echo $data->req_nbi_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_nbi_file">
                                                <em><a target="_blank" href="<?php echo $data->req_nbi_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_nbi_file"
                                                   value="<?php echo $data->req_nbi_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>Birth Certificate</td>
                                            <td>
                                                <input <?php echo $data->req_birth_cert_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox"
                                                        name="req_birth_cert_check"></td>
                                            <td><input class="form-control" type="date" name="req_birth_cert_date"
                                                       value="<?php echo $data->req_birth_cert_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_birth_cert_file">
                                                <em><a target="_blank" href="<?php echo $data->req_birth_cert_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_birth_cert_file"
                                                   value="<?php echo $data->req_birth_cert_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>Certificate of Marriage (For Married)</td>
                                            <td>
                                                <input <?php echo $data->req_cert_married_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox"
                                                        name="req_cert_married_check"></td>
                                            <td><input class="form-control" type="date" name="req_cert_married_date"
                                                       value="<?php echo $data->req_cert_married_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_cert_married_file">
                                                <em><a target="_blank"
                                                       href="<?php echo $data->req_cert_married_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_cert_married_file"
                                                   value="<?php echo $data->req_cert_married_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>Working/Mayor's Permit</td>
                                            <td>
                                                <input <?php echo $data->req_work_permit_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox"
                                                        name="req_work_permit_check"></td>
                                            <td><input class="form-control" type="date" name="req_work_permit_date"
                                                       value="<?php echo $data->req_work_permit_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_work_permit_file">
                                                <em><a target="_blank" href="<?php echo $data->req_work_permit_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_work_permit_file"
                                                   value="<?php echo $data->req_work_permit_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>1x1 ID Picture</td>
                                            <td>
                                                <input <?php echo $data->req_id_picture_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox"
                                                        name="req_id_picture_check"></td>
                                            <td><input class="form-control" type="date" name="req_id_picture_date"
                                                       value="<?php echo $data->req_id_picture_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_id_picture_file">
                                                <em><a target="_blank" href="<?php echo $data->req_id_picture_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_id_picture_file"
                                                   value="<?php echo $data->req_id_picture_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>Drug Test</td>
                                            <td><input <?php echo $data->req_drug_test_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox" name="req_drug_test_check">
                                            </td>
                                            <td><input class="form-control" type="date" name="req_drug_test_date"
                                                       value="<?php echo $data->req_drug_test_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_drug_test_file">
                                                <em><a target="_blank" href="<?php echo $data->req_drug_test_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_drug_test_file"
                                                   value="<?php echo $data->req_drug_test_file ?>">
                                        </tr>
                                        <tr class="<?php echo ($sl & 1) ? "odd gradeX" : "even gradeC" ?>">
                                            <td>Driver's License</td>
                                            <td>
                                                <input <?php echo $data->req_driver_license_check == 'on' ? 'checked' : '' ?>
                                                        class="form-control" type="checkbox"
                                                        name="req_driver_license_check"></td>
                                            <td><input class="form-control" type="date" name="req_driver_license_date"
                                                       value="<?php echo $data->req_driver_license_date ?>"></td>
                                            <td><input class="form-control" type="file" name="req_driver_license_file">
                                                <em><a target="_blank"
                                                       href="<?php echo $data->req_driver_license_file ?>">Current
                                                        Attachment</a></em>
                                            </td>
                                            <input type="hidden" name="old_req_driver_license_file"
                                                   value="<?php echo $data->req_driver_license_file ?>">
                                        </tr>
                                        </tbody>
                                    </table>  <!-- /.table-responsive -->

                                </div>


                                <div class="form-group form-group-margin text-right">

                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf_bankInfo()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="emergencycontact" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                                <div class="row">

                                    <h2>Emergency Contact Person 1</h2>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="name_emg_contact_person_1"><?php echo "Name" ?><sup
                                                        class="color-red ">*</sup></label>
                                            <input type="text" class="form-control" id="name_emg_contact_person_1"
                                                   name="name_emg_contact_person_1"
                                                   placeholder="<?php echo "Emergency Contact Person 1" ?>"
                                                   value="<?php echo $data->name_emg_contact_person_1 ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="relation_emg_contact_person_1"><?php echo "Relation" ?><sup
                                                        class="color-red ">*</sup></label>
                                            <input type="text" class="form-control" id="relation_emg_contact_person_1"
                                                   name="relation_emg_contact_person_1"
                                                   placeholder="<?php echo "Relation with the Contact Person 1" ?>"
                                                   value="<?php echo $data->relation_emg_contact_person_1 ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="phone_emg_contact_person_1"><?php echo "Phone number" ?><sup
                                                        class="color-red ">*</sup></label>
                                            <input type="number" class="form-control" id="phone_emg_contact_person_1"
                                                   name="phone_emg_contact_person_1"
                                                   placeholder="<?php echo "Phone number of the Emergency Contact Person 1" ?>"
                                                   value="<?php echo $data->phone_emg_contact_person_1 ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="alt_phone_emg_contact_person_1"><?php echo "Alternate Contact No." ?></label>
                                            <input type="number" class="form-control"
                                                   id="alt_phone_emg_contact_person_1"
                                                   name="alt_phone_emg_contact_person_1"
                                                   placeholder="<?php echo "Alternate Contact no. of Emergency Contact Person 1" ?>"
                                                   value="<?php echo $data->alt_phone_emg_contact_person_1 ?>">
                                        </div>
                                    </div>

                                </div>

                                <div class="row">

                                    <h2>Emergency Contact Person 2</h2>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="name_emg_contact_person_2"><?php echo "Name" ?></label>
                                            <input type="text" class="form-control" id="name_emg_contact_person_2"
                                                   name="name_emg_contact_person_2"
                                                   placeholder="<?php echo "Emergency Contact Person 2" ?>"
                                                   value="<?php echo $data->name_emg_contact_person_2 ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="relation_emg_contact_person_2"><?php echo "Relation" ?></label>
                                            <input type="text" class="form-control" id="relation_emg_contact_person_2"
                                                   name="relation_emg_contact_person_2"
                                                   placeholder="<?php echo "Relation with the Contact Person 2" ?>"
                                                   value="<?php echo $data->relation_emg_contact_person_2 ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="phone_emg_contact_person_2"><?php echo "Phone number" ?></label>
                                            <input type="number" class="form-control" id="phone_emg_contact_person_2"
                                                   name="phone_emg_contact_person_2"
                                                   placeholder="<?php echo "Phone number of the Emergency Contact Person 2" ?>"
                                                   value="<?php echo $data->phone_emg_contact_person_2 ?>">
                                        </div>
                                    </div>

                                    <div class="col-sm-3">
                                        <div class="form-group form-group-margin">
                                            <label for="alt_phone_emg_contact_person_2"><?php echo "Alternate Contact No." ?></label>
                                            <input type="number" class="form-control"
                                                   id="alt_phone_emg_contact_person_2"
                                                   name="alt_phone_emg_contact_person_2"
                                                   placeholder="<?php echo "Alternate Contact no. of Emergency Contact Person 2" ?>"
                                                   value="<?php echo $data->alt_phone_emg_contact_person_2 ?>">
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">

                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf6()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="menu7" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">
                    <span>
                    <?php foreach ($custominfo as $custom) { ?>
                        <div class="row">
                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="c_f_name"><?php echo 'Custom Field Name'; ?></label>
                                        <input type="text" class="form-control" id="c_f_name"
                                               name="c_f_name[]" value="<?php echo $custom->custom_field; ?>"
                                               placeholder="Custom Field Name">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group form-group-margin">
                                        <label for="c_f_type"><?php echo 'Custom Field Type'; ?></label>
                                       <select name="c_f_type[]" class="form-control">
                                        <option value="1" <?php if ($custom->custom_data_type == 1) {
                                            echo 'selected';
                                        } ?>>Text</option>
                                        <option value="2" <?php if ($custom->custom_data_type == 2) {
                                            echo 'selected';
                                        } ?>>Date</option>
                                        <option value="3" <?php if ($custom->custom_data_type == 3) {
                                            echo 'selected';
                                        } ?>>Text Area</option>
                                    </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group form-group-new form-group-margin-left">
                                        <label for="reports"><?php echo 'Custom Value' ?> </label>
                                            <input type="text" name="customvalue[]" class="form-control"
                                                   placeholder="custom value"
                                                   value="<?php echo $custom->custom_data; ?>">

                                    </div>
                                </div>

                            </div>

                    <?php } ?>
                        <?php if (empty($custominfo)) { ?>
                            <div class="row">
                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="c_f_name"><?php echo 'Custom Field Name'; ?></label>
                                        <input type="text" class="form-control" id="c_f_name"
                                               name="c_f_name[]" value="<?php echo $custom->custom_field; ?>"
                                               placeholder="Custom Field Name">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group form-group-margin">
                                        <label for="c_f_type"><?php echo 'Custom Field Type'; ?></label>
                                       <select name="c_f_type[]" class="form-control">
                                        <option value="1" <?php if ($custom->custom_data_type == 1) {
                                            echo 'selected';
                                        } ?>>Text</option>
                                        <option value="2" <?php if ($custom->custom_data_type == 2) {
                                            echo 'selected';
                                        } ?>>Date</option>
                                        <option value="3" <?php if ($custom->custom_data_type == 3) {
                                            echo 'selected';
                                        } ?>>Text Area</option>
                                    </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group form-group-new form-group-margin-left">
                                        <label for="reports"><?php echo 'Custom Value' ?> </label>
                                            <input type="text" name="customvalue[]" class="form-control"
                                                   placeholder="custom value"
                                                   value="<?php echo $custom->custom_data; ?>">

                                    </div>
                                </div>

                            </div>
                        <?php } ?>
                      </span>

                                <div id="add" class="toggle">
                            <span>
                      <div class="row">
                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="c_f_name"><?php echo 'Custom Field Name'; ?></label>
                                        <input type="text" class="form-control" id="c_f_name"
                                               name="c_f_name[]" placeholder="Custom Field Name">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group form-group-margin">
                                        <label for="c_f_type"><?php echo 'Custom Field Type'; ?></label>
                                       <select name="c_f_type[]" class="form-control">
                                        <option value="1">Text</option>
                                        <option value="2">Date</option>
                                        <option value="3">Text Area</option>
                                    </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group form-group-new form-group-margin-left">
                                        <label for="reports"><?php echo 'Custom Value' ?> </label>
                                            <input type="text" name="customvalue[]" class="form-control"
                                                   placeholder="custom value">

                                    </div>
                                </div>

                            </div>
                        </span>
                                    <div id="add" class="toggle">
                                <span>
                      <div class="row">
                  <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="c_f_name"><?php echo 'Custom Field Name'; ?></label>
                                        <input type="text" class="form-control" id="c_f_name"
                                               name="c_f_name[]" placeholder="Custom Field Name">
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group form-group-margin">
                                        <label for="c_f_type"><?php echo 'Custom Field Type'; ?></label>
                                       <select name="c_f_type[]" class="form-control">
                                        <option value="1">Text</option>
                                        <option value="2">Date</option>
                                        <option value="3">Text Area</option>
                                    </select>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group form-group-new form-group-margin-left">
                                        <label for="reports"><?php echo 'Custom Value' ?> </label>
                                            <input type="text" name="customvalue[]" class="form-control"
                                                   placeholder="custom value">

                                    </div>
                                </div>

                            </div>
                        </span>
                                    </div>
                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-primary btnNext" onclick="valid_inf_custom()"
                                           value="NEXT">
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="menu8" class="tab-pane fade">
                <div class="row">
                    <div class="col-sm-12 col-md-12 employee-form">
                        <div class="panel">

                            <div class="panel-body">

                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="s_name"><?php echo display('user_email') ?> <sup
                                                        class="color-red ">*</sup></label>

                                            <input type="email" class="form-control" id="user_email"
                                                   name="user_email" readonly=""
                                                   placeholder="<?php echo display('user_email') ?>"
                                                   value="<?php echo $data->email; ?>">
                                            <input type="hidden" name="old_useremail"
                                                   value="<?php echo $data->email; ?>">

                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="e_h_phone"><?php echo display('password') ?> <sup
                                                        class="color-red "></sup></label>
                                            <input type="password" class="form-control" id="password"
                                                   name="password" placeholder="<?php echo display('password') ?>">
                                            <input type="hidden" name="old_password"
                                                   value="<?php echo $data->password; ?>">
                                        </div>
                                    </div>

                                </div>


                                <div class="form-group form-group-margin text-right">
                                    <input type="button" class="btn btn-primary btnPrevious" value="Previous">
                                    <input type="button" class="btn btn-success" onclick="valid_inf8()" value="Update">
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <input type="submit" class="btn btn-success float-right" value="Update">
            <?php echo form_close() ?>
        </div>
    </div>
</div>

<!-- Vacation Time -->
<div id="vacationadd" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Add Vacation Time Record</h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_vacation_time') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id" value="<?php echo $data->employee_id; ?>">

                                    <label for="vacation_date" class="col-sm-3 col-form-label">
                                        <?php echo "Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="vacation_date" placeholder="<?php echo "Date" ?>"
                                               class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="certificate_number" class="col-sm-3 col-form-label">
                                        <?php echo "V. Time Hours" ?></label>
                                    <div class="col-sm-9">
                                        <input type="number" name="vacation_hours"
                                               placeholder="<?php echo "V. Time Hours" ?>" class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Description" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="vacation_description" name="vacation_description"
                                                  placeholder="<?php echo "Description" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="vacation_save"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<div id="vacationupdate" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Update Vacation Time Record</h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_vacation_time') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id_update"
                                           value="<?php echo $data->employee_id; ?>">

                                    <label for="vacation_date" class="col-sm-3 col-form-label">
                                        <?php echo "Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="vacation_date_update"
                                               placeholder="<?php echo "Date" ?>"
                                               class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="certificate_number" class="col-sm-3 col-form-label">
                                        <?php echo "V. Time Hours" ?></label>
                                    <div class="col-sm-9">
                                        <input type="number" name="vacation_hours_update"
                                               placeholder="<?php echo "V. Time Hours" ?>" class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Description" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="vacation_description_update" name="vacation_description_update"
                                                  placeholder="<?php echo "Description" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="vacation_update"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<!-- Personal Time -->
<div id="personaladd" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Add Personal Time Record</h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_personal_time') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id" value="<?php echo $data->employee_id; ?>">

                                    <label for="personal_date" class="col-sm-3 col-form-label">
                                        <?php echo "Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="personal_date" placeholder="<?php echo "Date" ?>"
                                               class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="personal_hours" class="col-sm-3 col-form-label">
                                        <?php echo "P. Time Hours" ?></label>
                                    <div class="col-sm-9">
                                        <input type="number" name="personal_hours"
                                               placeholder="<?php echo "P. Time Hours" ?>" class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Description" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="personal_description" name="personal_description"
                                                  placeholder="<?php echo "Description" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="personal_save"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<div id="personalupdate" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Update Personal Time Record</h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_personal_time') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id_update"
                                           value="<?php echo $data->employee_id; ?>">

                                    <label for="personal_date" class="col-sm-3 col-form-label">
                                        <?php echo "Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="personal_date_update"
                                               placeholder="<?php echo "Date" ?>"
                                               class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="certificate_number" class="col-sm-3 col-form-label">
                                        <?php echo "P. Time Hours" ?></label>
                                    <div class="col-sm-9">
                                        <input type="number" name="personal_hours_update"
                                               placeholder="<?php echo "P. Time Hours" ?>" class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Description" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="personal_description_update" name="personal_description_update"
                                                  placeholder="<?php echo "Description" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="personal_update"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<!-- Wage -->
<div id="wageadd" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Add Job History Record</h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_wage_history') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id" value="<?php echo $data->employee_id; ?>">

                                    <label for="wage_job_title" class="col-sm-3 col-form-label">
                                        <?php echo "Job Title" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_job_title" placeholder="<?php echo "Job Title" ?>"
                                               class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="wage_name" class="col-sm-3 col-form-label">
                                        <?php echo "Wage" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_name"
                                               placeholder="<?php echo "Wage" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_type" class="col-sm-3 col-form-label">
                                        <?php echo "Type" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_type"
                                               placeholder="<?php echo "Type" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_band" class="col-sm-3 col-form-label">
                                        <?php echo "Band" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_band"
                                               placeholder="<?php echo "Band" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_step" class="col-sm-3 col-form-label">
                                        <?php echo "Step" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_step"
                                               placeholder="<?php echo "Step" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_start_date" class="col-sm-3 col-form-label">
                                        <?php echo "Start Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="wage_start_date"
                                               placeholder="<?php echo "Start Date" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_end_date" class="col-sm-3 col-form-label">
                                        <?php echo "End Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="wage_end_date"
                                               placeholder="<?php echo "End Date" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_department" class="col-sm-3 col-form-label">
                                        <?php echo "Department" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_department"
                                               placeholder="<?php echo "Department" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_manager" class="col-sm-3 col-form-label">
                                        <?php echo "Manager" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_manager"
                                               placeholder="<?php echo "Manager" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_comments" class="col-sm-3 col-form-label">
                                        <?php echo "Comments" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="wage_comments" name="wage_comments"
                                                  placeholder="<?php echo "Comments" ?>"
                                                  class=" form-control"></textarea>
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="wage_save"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<div id="wageupdate" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Add Job History Record</h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_wage_history') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id_update"
                                           value="<?php echo $data->employee_id; ?>">

                                    <label for="wage_job_title" class="col-sm-3 col-form-label">
                                        <?php echo "Job Title" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_job_title_update"
                                               placeholder="<?php echo "Job Title" ?>"
                                               class=" form-control">

                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="wage_name" class="col-sm-3 col-form-label">
                                        <?php echo "Wage" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_name_update"
                                               placeholder="<?php echo "Wage" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_type" class="col-sm-3 col-form-label">
                                        <?php echo "Type" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_type_update"
                                               placeholder="<?php echo "Type" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_band" class="col-sm-3 col-form-label">
                                        <?php echo "Band" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_band_update"
                                               placeholder="<?php echo "Band" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_step" class="col-sm-3 col-form-label">
                                        <?php echo "Step" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_step_update"
                                               placeholder="<?php echo "Step" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_start_date" class="col-sm-3 col-form-label">
                                        <?php echo "Start Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="wage_start_date_update"
                                               placeholder="<?php echo "Start Date" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_end_date" class="col-sm-3 col-form-label">
                                        <?php echo "End Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="wage_end_date_update"
                                               placeholder="<?php echo "End Date" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_department" class="col-sm-3 col-form-label">
                                        <?php echo "Department" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_department_update"
                                               placeholder="<?php echo "Department" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_manager" class="col-sm-3 col-form-label">
                                        <?php echo "Manager" ?></label>
                                    <div class="col-sm-9">
                                        <input type="text" name="wage_manager_update"
                                               placeholder="<?php echo "Manager" ?>" class=" form-control">
                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="wage_comments" class="col-sm-3 col-form-label">
                                        <?php echo "Comments" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="wage_comments_update" name="wage_comments_update"
                                                  placeholder="<?php echo "Comments" ?>"
                                                  class=" form-control"></textarea>
                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="wage_update"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<div id="disciplinaryadd" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Add Disciplinary Action Record
                        </h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_disciplinary_action') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id" value="<?php echo $data->employee_id; ?>">

                                    <label for="disciplinary_date" class="col-sm-3 col-form-label">
                                        <?php echo "Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="disciplinary_date" placeholder="<?php echo "Date" ?>"
                                               class=" form-control">

                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="disciplinary_comments" class="col-sm-3 col-form-label">
                                        <?php echo "Comments" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="disciplinary_comments" name="disciplinary_comments"
                                                  placeholder="<?php echo "Comments" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="disciplinary_save"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<div id="disciplinaryupdate" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i>Add Disciplinary Action Record
                        </h4>
                    </strong></center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/create_disciplinary_action') ?>

                                <div class="form-group row">

                                    <input type="hidden" name="employee_id" value="<?php echo $data->employee_id; ?>">

                                    <label for="disciplinary_date_update" class="col-sm-3 col-form-label">
                                        <?php echo "Date" ?></label>
                                    <div class="col-sm-9">
                                        <input type="date" name="disciplinary_date_update"
                                               placeholder="<?php echo "Date" ?>"
                                               class=" form-control">

                                    </div>

                                </div>

                                <div class="form-group row">

                                    <label for="disciplinary_comments_update" class="col-sm-3 col-form-label">
                                        <?php echo "Comments" ?></label>
                                    <div class="col-sm-9">
                                        <textarea id="disciplinary_comments_update" name="disciplinary_comments_update"
                                                  placeholder="<?php echo "Comments" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>

                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit" id="disciplinary_update"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="modal-footer">

        </div>

    </div>

</div>

<!-- ConfirmationModal Start -->
<div id="ConfirmationModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i> Confirmation </h4></strong>
                </center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/update_salary_position') ?>

                                <div class="form-group row">
                                    <!--                                    Hidden Fields-->
                                    <input type="hidden" id="hidden_id_model_conformation"
                                           name="hidden_id_model_conformation" class="form-control">
                                    <input type="hidden" id="fname_modal_sal" name="fname_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="lname_modal_sal" name="lname_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="email_modal_sal" name="email_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="position_modal_sal" name="position_modal_sal"
                                           class="form-control">
                                    <input type="hidden" id="current_salary" name="current_salary"
                                           class="form-control">

                                    <label for="certificate_name" class="col-sm-3 col-form-label">
                                        <?php echo "Update Salary" ?></label>
                                    <div class="col-sm-9">
                                        <input type="number" id="salary" name="salary"
                                               placeholder="<?php echo "Update Salary" ?>" class=" form-control">
                                    </div>
                                </div>
                                <div class="form-group row">

                                    <label for="employee_id" class="col-sm-3 col-form-label">
                                        <?php echo "Position update"; ?></label>
                                    <div class="col-sm-9">
                                        <!--                                        --><?php //echo form_dropdown('employee_id',$dropdown,null,'class="form-control codeigniterselect"') ?>
                                        <select name="designation" id="designation" class="form-control">
                                            <option value="">select Designation</option>
                                            <!--                                            <option value=""  disabled selected hidden> </option>-->
                                            <?php foreach ($designation as $desig) { ?>
                                                <option value="<?php echo $desig->pos_id ?>"><?php echo $desig->position_name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                </div>
                                <div class="form-group row">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Comment" ?></label>
                                    <div class="col-sm-9">
                                        <textarea name="comment" placeholder="<?php echo "Enter Comment" ?>"
                                                  class=" form-control"></textarea>

                                    </div>

                                </div>
                                <div class="form-group form-group-margin text-right">
                                    <button type="reset"
                                            class="btn btn-primary w-md m-b-5"><?php echo display('reset') ?></button>
                                    <button type="submit"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>
                                <?php echo form_close() ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>

</div>
<!--ConfirmationModal END-->

<!--TerminationModal Start-->
<div id="TerminationModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i> Warning </h4></strong>
                </center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/update_warning') ?>

                                <div class="form-group row" id="ter_div_1">
                                    <input type="hidden" id="hidden_id_model_termination"
                                           name="hidden_id_model_termination" class="form-control">
                                    <input type="hidden" id="hidden_warning_no_model" name="hidden_warning_no_model"
                                           class="form-control">
                                    <input type="hidden" id="fname_modal_ter" name="fname_modal_ter"
                                           class="form-control">
                                    <input type="hidden" id="lname_modal_ter" name="lname_modal_ter"
                                           class="form-control">
                                    <input type="hidden" id="email_modal_ter" name="email_modal_ter"
                                           class="form-control">
                                    <input type="hidden" id="position_modal_ter" name="position_modal_ter"
                                           class="form-control">

                                </div>

                                <div class="form-group row" id="ter_div_2">

                                    <label for="ct_description" class="col-sm-3 col-form-label">
                                        <?php echo "Reason" ?></label>
                                    <div class="col-sm-9">
                                        <textarea name="reason" placeholder="<?php echo "Enter Reason" ?>"
                                                  class=" form-control" required></textarea>

                                    </div>

                                </div>
                                <div class="form-group form-group-margin text-right" id="ter_div_3">
                                    <!--                                    <button type="reset" class="btn btn-primary w-md m-b-5">-->
                                    <?php //echo display('reset') ?><!--</button>-->
                                    <button type="submit" id="btn_save_termination"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>

                                <?php echo form_close() ?>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>

</div>
<!--TerminationModal End-->

<!--Terminate Modal Start-->
<div id="terminateModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong><h4><i class='fa fa-certificate' aria-hidden='true'></i> Terminate </h4></strong>
                </center>
            </div>
            <div class="modal-body">


                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="panel">
                            <div class="panel-heading">
                                <div class="panel-title">

                                </div>
                            </div>
                            <div class="panel-body">

                                <?php echo form_open_multipart('employee/Employees/terminate') ?>

                                <div class="form-group row">
                                    <input type="hidden" id="ter_emp_id"
                                           name="ter_emp_id" class="form-control">
                                    <input type="hidden" id="ter_first_name" name="ter_first_name"
                                           class="form-control">
                                    <input type="hidden" id="ter_last_name" name="ter_last_name"
                                           class="form-control">
                                    <input type="hidden" id="ter_email" name="ter_email"
                                           class="form-control">

                                </div>

                                <div class="form-group row" id="ter_div_2">

                                    <label for="ter_description" class="col-sm-3 col-form-label">
                                        <?php echo "Reason" ?></label>
                                    <div class="col-sm-9">
                                        <textarea name="ter_reason" placeholder="<?php echo "Enter Reason" ?>"
                                                  class=" form-control" required></textarea>

                                    </div>

                                </div>
                                <div class="form-group form-group-margin text-right" id="ter_div_3">
                                    <!--                                    <button type="reset" class="btn btn-primary w-md m-b-5">-->
                                    <?php //echo display('reset') ?><!--</button>-->
                                    <button type="submit" id="btn_save_terminate"
                                            onclick="return confirm('Are you sure to terminate this employee? You cannot edit once termination email has been sent.')"
                                            class="btn btn-success w-md m-b-5"><?php echo display('save') ?></button>
                                </div>

                                <?php echo form_close() ?>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

    </div>

</div>
<!--Terminate Modal End-->

<script src="<?php echo base_url('assets/js/employee.js') ?>" type="text/javascript"></script>
<script src="<?php echo MOD_URL . 'employee/assets/js/script.js'; ?>" type="text/javascript"></script>