<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Certificate_model extends CI_Model {
 
    public function certificate_view()
	{
        return $this->db->select('count(DISTINCT(ct.certificate_id)) as certificate_id,ct.*,p.employee_id,p.first_name,p.last_name')
            ->from('certificate ct')
            ->join('employee_history p', 'ct.employee_id = p.employee_id', 'left')
            ->group_by('ct.certificate_id')
            ->order_by('ct.certificate_id', 'desc')
            ->get()
            ->result();
	}
    public function dropdown(){
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where('employee_status',1);
        $query=$this->db->get();
        $data=$query->result();
        $list = array('' => 'Select One...');
        if(!empty($data)){
            foreach ($data as  $value) {
                $list[$value->employee_id]=$value->first_name." ".$value->last_name;
            }
        }
        return $list;
    }

    public function certificate_create($data = array())
    {
        return $this->db->insert('certificate', $data);
    }

    public function update_certificate($data = array())
    {
        return $this->db->where('certificate_id',$data["certificate_id"])
            ->update("certificate", $data);
    }
    public function certificate_updateForm($id){
        $this->db->where('certificate_id',$id);
        $query = $this->db->get('certificate');
        return $query->row();
    }
    public  function get_id($id)
    {
        $query=$this->db->get_where('certificate',array('certificate_id'=>$id));
        return $query->row_array();
    }

    public function certificate_delete($id = null)
    {
        $this->db->where('certificate_id',$id)
            ->delete('certificate');

        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }

}
